#$baseURL = "https://192.168.2.136:4450/admin"
#$baseURL = "https://192.168.100.165:4450/admin"
$baseURL = "https://172.31.120.143:4450/admin"
$AdminUser = "admin"
$password = "alaska"

# Only to ignore certificates errors
add-type @"
    using System.Net;
    using System.Security.Cryptography.X509Certificates;

        public class IDontCarePolicy : ICertificatePolicy {
        public IDontCarePolicy() {}
        public bool CheckValidationResult(
            ServicePoint sPoint, X509Certificate cert,
            WebRequest wRequest, int certProb) {
            return true;
        }
    }
"@
[System.Net.ServicePointManager]::CertificatePolicy = new-object IDontCarePolicy 
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12


# authentication
$authBody = "{""userName"": ""$AdminUser"", ""password"": ""$password"", ""authType"": ""EFT""}"
$auth = Invoke-RestMethod -Uri "$baseURL/v1/authentication" -Method 'POST' -Body $authBody

$authToken = $auth.authToken
$authHeader = New-Object "System.Collections.Generic.Dictionary[[String],[String]]"
$authHeader.Add("Authorization", "EFTAdminAuthToken $authToken")


# get sites
Write-Output "Site"
Write-Output "----"
$siteList = Invoke-RestMethod -Uri "$baseURL/v2/sites" -Method 'GET' -Headers $authHeader
Write-Output $siteList | ConvertTo-Json
foreach ($site in $siteList.data)
{
    Write-Output ("Site  $($site.id): $($site.attributes.name)")
}

$siteID = $siteList.data[0].id

# get users
Write-Output "Users"
Write-Output "-----"
$userList = Invoke-RestMethod -Uri "$baseURL/v2/sites/$siteID/users" -Method 'GET' -Headers $authHeader
Write-Output $userList | ConvertTo-Json
foreach ($user in $userList.data)
{
    Write-Output ("User $($user.id): $($user.attributes.loginName)")
}

########################################################################################################
#Added as of 10/8/21

#get Server
Write-Output "Get Server"
Write-Output "-----"
$serverDetails = Invoke-RestMethod -Uri "$baseURL/v2/server" -Method 'GET' -Headers $authHeader
Write-Output $serverDetails | ConvertTo-Json
foreach ($server in $serverDetails.data)
{
    Write-Output ("Server $($serverDetails.data)")
}

##Patch Server - patching the SMTP settings
Write-Output "Server Patch"
Write-Output "-----"
$update = 
'{
    "data":{
        "type": "server",
        "id": "1",
        "attributes": {
            "version": "",
        "smtp": {
            "login": "",
            "password": "",
            "port": 25,
            "senderAddr": "EFT@iv-s2019b-1.com",
            "senderName": "Globalscape EFT",
            "server": "mail.yada2.net",
            "useAuthentication": false,
            "useImplicitTLS": false
         }  
         }
     }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/server" -Method 'PATCH' -Headers $authHeader -Body $update

###
#get Server Metrics
Write-Output "Get Server Metrics"
Write-Output "-----"
$serverMetrics = Invoke-RestMethod -Uri "$baseURL/v2/server/metrics" -Method 'GET' -Headers $authHeader
Write-Output $serverMetrics | ConvertTo-Json
foreach ($server in $serverMetrics.data)
{
    Write-Output ("Server $($serverMetrics.data)")
}

###
#get Server TLS Security Settings
Write-Output "Get Server TLS Settings"
Write-Output "-----"
$serverTLS = Invoke-RestMethod -Uri "$baseURL/v2/server/security/tls" -Method 'GET' -Headers $authHeader
Write-Output $serverTLS | ConvertTo-Json
foreach ($server in $serverTLS.data)
{
    Write-Output ("Server $($serverTLS.data)")
}

###(PATCH) TLS Security Settings (enable FIPS)
Write-Output "Server TLS Enable FIPS Patch"
Write-Output "-----"
$update = 
'{
 "data": {
    "type": "tlsServerSecuritySettings",
    "id": "1",
    "attributes": {
      "tlsFipsEnabled": true
    }
  },
  "links": {
    "self": "admin/v2/server/security/tls"
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/server/security/tls" -Method 'PATCH' -Headers $authHeader -Body $update



###
#get Server SSH Security Settings
Write-Output "Get Server SSH Settings"
Write-Output "-----"
$serverSSH = Invoke-RestMethod -Uri "$baseURL/v2/server/security/ssh" -Method 'GET' -Headers $authHeader
Write-Output $serverSSH | ConvertTo-Json
foreach ($server in $serverSSH.data)
{
    Write-Output ("Server $($serverSSH.data)")
}

###(PATCH) SSH Security Settings (enable FIPS)
Write-Output "Server SSH Enable FIPS Patch"
Write-Output "-----"
$update = 
'{
 "data": {
    "type": "sshServerSecurity",
    "id": "1",
    "attributes": {
      "sshFipsEnabled": true
    }
  },
  "links": {
    "self": "admin/v2/server/security/ssh"
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/server/security/ssh" -Method 'PATCH' -Headers $authHeader -Body $update


###
#get Server DPIA Report
Write-Output "Get Server DPIA Report"
Write-Output "-----"
$serverDPIA = Invoke-RestMethod -Uri "$baseURL/v2/server/reports/DPIA" -Method 'GET' -Headers $authHeader
Write-Output $serverDPIA | ConvertTo-Json -Depth 20
foreach ($server in $serverDPIA.data)
{
    Write-Output ("Server $($serverDPIA.data)")
}

###
#get Server admin users
Write-Output "Get Server admin users"
Write-Output "-----"
$serverAdmins = Invoke-RestMethod -Uri "$baseURL/v2/admin-users" -Method 'GET' -Headers $authHeader
Write-Output $serverAdmins | ConvertTo-Json
foreach ($server in $serverAdmins.data)
{
    Write-Output ("Server $($serverAdmins.data)")
}

###
#POST Server Admin user (New User)
Write-Output "POST Server Admin (New Admin user)"
Write-Output "-----"
$update = 
'{
  "data": {
    "id": "1",
    "attributes": {
      "name": "Test_admin",
      "password": "test",
      "adminConsolePermissions": {
        "accountPolicy": "server",
        "enableCom": true,
        "enableEditingAndReporting": true,
        "enablePersonalDataAccess": true
      },
      "restPermissions": {
        "enabled": true,
        "restAdminRole": true
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/admin-users" -Method 'POST' -Headers $authHeader -Body $update

###
#Get Server Admin Details when providing a Server Admin ID
Write-Output "Get Server Admin Details"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/admin-users/59774c12-870d-5560-a44a-c5b35cf68d4c" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($server in $serverAdminDetails.data)
{
    Write-Output ("Server $($serverAdminDetails.data)")
}


###
#PATCH Server Admin Details when providing a Server Admin ID
Write-Output "Server Admin User Patch"
$adminID = "13564c1b-8e13-4e72-b8e0-9480fad06221"
Write-Output "Admin ID: $adminID"
Write-Output "-----"
$update = 
'{
  "data": {
    "id": "0",
    "attributes": {
        "adminConsolePermissions": {
        "enableCom": false,
        "enableEditingAndReporting": true,
        "enablePersonalDataAccess": true
      },
      "restPermissions": {
        "enabled": true,
        "restAdminRole": true
      }
    }
  }
}'
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/admin-users/$adminID" -Method 'PATCH' -Headers $authHeader -Body $update


###
#DELETE EFT admin by Admin ID
Write-Output "Server Admin DELETE"
$adminID = "f98d2a35-4d37-4891-89ed-66cb6ddf9436"
Write-Output "Admin ID: $adminID"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/admin-users/$adminID" -Method 'DELETE' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($server in $serverAdminDetails.data)
{
    Write-Output ("Server $($serverAdminDetails.data)")
}


###
#GET Server Admin user policy
Write-Output "Get Server Admin User Policy"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/admin-users-policy" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($server in $serverAdminDetails.data)
{
    Write-Output ("Server $($serverAdminDetails.data)")
}

###
#PATCH Server Admin user policy (disable Admin UI disconnect)
Write-Output "Server Admin User Policy Patch"
Write-Output "-----"
$update = 
'{
  "data": {
    "id": "1",
    "type": "adminUserPolicy",
    "attributes": {
      "accountPolicy": {
          "inactivity": {
          "disconnectDueToTimeout": {
            "enabled": false,
            "timeoutMinutes": 5
          }

        }
      }
    }
  }
}'   
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/admin-users-policy" -Method 'PATCH' -Headers $authHeader -Body $update

###
#GET SERVER NODES
Write-Output "Get EFT Server Nodes"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/nodes" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($server in $serverAdminDetails.data)
{
    Write-Output ("Server $($serverAdminDetails.data)")
}

###
#GET SERVER NODE METRICS
Write-Output "Get EFT Server Node Metrics"
$serverNodeID = "WIN-4NFJASSP163"
Write-Output "Server Node ID: $serverNodeID"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/nodes/$serverNodeID/metrics" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10
foreach ($server in $serverAdminDetails.data)
{
    Write-Output ("Server $($serverAdminDetails.data)")
}

###
#GET SERVER NODE LICENSE
Write-Output "Get EFT Server Node Licenses"
$serverNodeID = "WIN-4NFJASSP163"
Write-Output "Server Node ID: $serverNodeID"
Write-Output "-----"
$serverAdminDetails = Invoke-RestMethod -Uri "$baseURL/v2/nodes/$serverNodeID/licenses" -Method 'GET' -Headers $authHeader
Write-Output $serverAdminDetails | ConvertTo-Json -Depth 10


###
#POST SERVER NODE LICENSE
Write-Output "Register EFT Server Node"
$serverNodeID = "WIN-4NFJASSP163"
Write-Output "Server Node ID: $serverNodeID"
Write-Output "-----"
$update = 
'{
  "data": [
    {
      "id": "ARMModule",
      "attributes": {
        "serialNumber": "MySerialNumberHere"
      }
    }
  ]
}'   
$update = $update | ConvertFrom-Json
$update = $update | ConvertTo-Json -Depth 10
$patchReturn = Invoke-RestMethod -Uri "$baseURL/v2/nodes/$serverNodeID/licenses" -Method 'POST' -Headers $authHeader -Body $update